/*
 * Decompiled with CFR 0.152.
 */
package com.github.josetto.kes;

import com.github.josetto.kes.KesApplication;
import com.github.josetto.kes.gui.actions.CalculateAction;
import com.github.josetto.kes.service.so.EcosystemSO;
import com.github.josetto.kes.service.so.ServicesSO;
import com.github.josetto.kes.utils.PointValuesEnum;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class KesApplication
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(KesApplication.class);
    private JTextField ecosystemAreaTextField;
    private JTextField outputTextField;
    private JTextField servicesValueTextField;
    private JTextField actualServicesValueTextField;
    private JPanel panel;

    public KesApplication() {
        this.setTitle("KES - Kalkula\u010dka ekosyst\u00e9mov\u00fdch slu\u017eieb");
        this.initComponents();
        this.initCustomComponents();
    }

    public static void main(String[] args) {
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[]{KesApplication.class}).web(WebApplicationType.NONE).headless(false).bannerMode(Banner.Mode.OFF).run(args);
        EventQueue.invokeLater(() -> {
            KesApplication app = (KesApplication)ctx.getBean(KesApplication.class);
            app.setVisible(true);
        });
    }

    private void initComponents() {
        this.setSize(new Dimension(1067, 523));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        JPanel inputPanel = new JPanel();
        inputPanel.setBounds(10, 10, 487, 197);
        inputPanel.setPreferredSize(new Dimension(200, 400));
        inputPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(inputPanel);
        inputPanel.setLayout(null);
        JComboBox<EcosystemSO> ecosystemComboBox = new JComboBox<EcosystemSO>();
        ecosystemComboBox.setFont(new Font("Tahoma", 0, 11));
        ecosystemComboBox.setBounds(10, 35, 168, 20);
        ecosystemComboBox.setModel(new DefaultComboBoxModel<EcosystemSO>(this.getEcosystem()));
        ecosystemComboBox.setMaximumRowCount(11);
        inputPanel.add(ecosystemComboBox);
        JLabel ecosystemLabel = new JLabel("Vyberte ekosyst\u00e9m");
        ecosystemLabel.setFont(new Font("Tahoma", 0, 11));
        ecosystemLabel.setBounds(10, 11, 168, 14);
        inputPanel.add(ecosystemLabel);
        this.ecosystemAreaTextField = new JTextField();
        this.ecosystemAreaTextField.setFont(new Font("Tahoma", 0, 11));
        this.ecosystemAreaTextField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.ecosystemAreaTextField.setToolTipText("Plocha v hekt\u00e1roch");
        this.ecosystemAreaTextField.setText("0");
        this.ecosystemAreaTextField.setBounds(208, 35, 122, 20);
        inputPanel.add(this.ecosystemAreaTextField);
        this.ecosystemAreaTextField.setColumns(10);
        JLabel ecosystemAreaLabel = new JLabel("Zadajte plochu v ha");
        ecosystemAreaLabel.setFont(new Font("Tahoma", 0, 11));
        ecosystemAreaLabel.setBounds(208, 11, 122, 14);
        inputPanel.add(ecosystemAreaLabel);
        JList<ServicesSO> servicesList = new JList<ServicesSO>(this.getServices());
        servicesList.setFont(new Font("Tahoma", 0, 11));
        servicesList.setBounds(350, 37, 114, 92);
        inputPanel.add(servicesList);
        JLabel servicesLabel = new JLabel("Vyberte slu\u017eby");
        servicesLabel.setFont(new Font("Tahoma", 0, 11));
        servicesLabel.setBounds(350, 11, 114, 14);
        inputPanel.add(servicesLabel);
        JButton calculateButton = new JButton("Spo\u010d\u00edtaj");
        calculateButton.setFont(new Font("Tahoma", 0, 11));
        calculateButton.setBounds(208, 148, 89, 23);
        inputPanel.add(calculateButton);
        JLabel servicesValueLabel = new JLabel("Hodnota slu\u017eieb v \u20ac");
        servicesValueLabel.setFont(new Font("Tahoma", 0, 11));
        servicesValueLabel.setBounds(10, 78, 103, 14);
        inputPanel.add(servicesValueLabel);
        this.servicesValueTextField = new JTextField();
        this.servicesValueTextField.setFont(new Font("Tahoma", 0, 11));
        this.servicesValueTextField.setText("40,7");
        this.servicesValueTextField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.servicesValueTextField.setBounds(10, 102, 122, 20);
        inputPanel.add(this.servicesValueTextField);
        this.servicesValueTextField.setColumns(10);
        JPanel outputPanel = new JPanel();
        outputPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        outputPanel.setBounds(10, 282, 487, 191);
        this.getContentPane().add(outputPanel);
        outputPanel.setLayout(null);
        JLabel outputLabel = new JLabel("Bodov\u00e1 hodnota pre: ");
        outputLabel.setFont(new Font("Tahoma", 0, 11));
        outputLabel.setBounds(10, 11, 113, 14);
        outputPanel.add(outputLabel);
        this.outputTextField = new JTextField();
        this.outputTextField.setFont(new Font("Tahoma", 0, 11));
        this.outputTextField.setEditable(false);
        this.outputTextField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.outputTextField.setText("0");
        this.outputTextField.setBounds(10, 76, 86, 20);
        outputPanel.add(this.outputTextField);
        this.outputTextField.setColumns(10);
        JTextArea outputTextArea = new JTextArea();
        outputTextArea.setFont(new Font("Tahoma", 0, 11));
        outputTextArea.setEditable(false);
        outputTextArea.setBackground(UIManager.getColor("EditorPane.disabledBackground"));
        outputTextArea.setBounds(120, 11, 113, 54);
        outputPanel.add(outputTextArea);
        JLabel actualServicesValueLabel = new JLabel("Aktu\u00e1lna hodnota slu\u017eieb v \u20ac");
        actualServicesValueLabel.setFont(new Font("Tahoma", 0, 11));
        actualServicesValueLabel.setBounds(291, 11, 146, 14);
        outputPanel.add(actualServicesValueLabel);
        this.actualServicesValueTextField = new JTextField();
        this.actualServicesValueTextField.setFont(new Font("Tahoma", 0, 11));
        this.actualServicesValueTextField.setEditable(false);
        this.actualServicesValueTextField.setText("0");
        this.actualServicesValueTextField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.actualServicesValueTextField.setBounds(291, 76, 86, 20);
        outputPanel.add(this.actualServicesValueTextField);
        this.actualServicesValueTextField.setColumns(10);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setPreferredSize(new Dimension(1233, 839));
        this.setDefaultCloseOperation(3);
        CalculateAction calculateAction = new CalculateAction(outputTextArea, this.outputTextField, ecosystemComboBox, this.ecosystemAreaTextField, servicesList, this.servicesValueTextField, this.actualServicesValueTextField);
        calculateButton.setAction((Action)calculateAction);
        calculateButton.setActionCommand("Button");
    }

    private ServicesSO[] getServices() {
        return new ServicesSO[]{new ServicesSO("PS", "Produk\u010dn\u00e9 slu\u017eby"), new ServicesSO("RS", "Regula\u010dn\u00e9 slu\u017eby"), new ServicesSO("KS", "Kult\u00farne slu\u017eby")};
    }

    private EcosystemSO[] getEcosystem() {
        return new EcosystemSO[]{new EcosystemSO(PointValuesEnum.OP.name(), "Orn\u00e9 p\u00f4dy"), new EcosystemSO(PointValuesEnum.TTP.name(), "Trval\u00e9 tr\u00e1vne porasty"), new EcosystemSO(PointValuesEnum.V.name(), "Vinice"), new EcosystemSO(PointValuesEnum.OS.name(), "Ovocn\u00e9 sady"), new EcosystemSO(PointValuesEnum.RD.name(), "R\u00fdchlorast\u00face dreviny"), new EcosystemSO(PointValuesEnum.VP.name(), "Vodn\u00e9 plochy"), new EcosystemSO(PointValuesEnum.MNV.name(), "Mokrade n\u00e1rodn\u00e9ho v\u00fdznamu"), new EcosystemSO(PointValuesEnum.N2000.name(), "NATURA 2000"), new EcosystemSO(PointValuesEnum.LH.name(), "Les hospod\u00e1rsky"), new EcosystemSO(PointValuesEnum.LO.name(), "Les ochrann\u00fd"), new EcosystemSO(PointValuesEnum.LIF.name(), "Les s inou funkciou")};
    }

    private void initCustomComponents() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOG.error("Uncaught exception detected: ", e));
        this.panel = new ImagePanel(this);
        this.panel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel.setBounds(513, 10, 528, 463);
        this.getContentPane().add(this.panel);
    }
}

