/*
 * Decompiled with CFR 0.152.
 */
package com.github.josetto.kes.gui.actions;

import com.github.josetto.kes.service.so.EcosystemSO;
import com.github.josetto.kes.service.so.ServicesSO;
import com.github.josetto.kes.utils.PointValuesEnum;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.math.NumberUtils;

public class CalculateAction
extends AbstractAction {
    private final JTextArea outputTextArea;
    private final JTextField outputTextField;
    private final JComboBox<EcosystemSO> ecosystemComboBox;
    private final JTextField ecosystemAreaTextField;
    private final JList<ServicesSO> servicesList;
    private final JTextField servicesValueTextField;
    private final JTextField actualServicesValueTextField;

    public CalculateAction(JTextArea outputTextArea, JTextField outputTextField, JComboBox<EcosystemSO> ecosystemComboBox, JTextField ecosystemAreaTextField, JList<ServicesSO> servicesList, JTextField servicesValueTextField, JTextField actualServicesValueTextField) {
        this.putValue("Name", (Object)"Spo\u010d\u00edtaj");
        this.putValue("ShortDescription", (Object)"Spo\u010d\u00edta, \u010do m\u00e1");
        this.outputTextArea = outputTextArea;
        this.outputTextField = outputTextField;
        this.ecosystemComboBox = ecosystemComboBox;
        this.ecosystemAreaTextField = ecosystemAreaTextField;
        this.servicesList = servicesList;
        this.servicesValueTextField = servicesValueTextField;
        this.actualServicesValueTextField = actualServicesValueTextField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List selectedServices = this.servicesList.getSelectedValuesList();
        if (this.ecosystemComboBox.getSelectedIndex() != -1 && selectedServices.size() != 0 && NumberUtils.isCreatable((String)this.ecosystemAreaTextField.getText()) && NumberUtils.isCreatable((String)this.servicesValueTextField.getText().replace(',', '.'))) {
            EcosystemSO ecosystemSO = (EcosystemSO)this.ecosystemComboBox.getItemAt(this.ecosystemComboBox.getSelectedIndex());
            PointValuesEnum pointValue = PointValuesEnum.valueOf((String)ecosystemSO.getValue());
            AtomicInteger bhcount = new AtomicInteger(0);
            StringBuilder sb = new StringBuilder();
            if (selectedServices.size() == 3) {
                bhcount.addAndGet(pointValue.getBhall());
                selectedServices.forEach(service -> sb.append(service.getLabel()).append("\n"));
            } else {
                selectedServices.forEach(service -> {
                    switch (service.getValue()) {
                        case "PS": {
                            bhcount.addAndGet(pointValue.getBhp());
                            break;
                        }
                        case "RS": {
                            bhcount.addAndGet(pointValue.getBhr());
                            break;
                        }
                        case "KS": {
                            bhcount.addAndGet(pointValue.getBhk());
                        }
                    }
                    sb.append(service.getLabel()).append("\n");
                });
            }
            String bhess = String.valueOf(bhcount.get() * Integer.parseInt(this.ecosystemAreaTextField.getText()));
            this.outputTextArea.setText(sb.toString().trim());
            this.outputTextField.setText(bhess);
            BigDecimal hb = NumberUtils.createBigDecimal((String)this.servicesValueTextField.getText().replace(',', '.'));
            BigDecimal ahb = hb.multiply(NumberUtils.createBigDecimal((String)bhess));
            this.actualServicesValueTextField.setText(NumberFormat.getCurrencyInstance().format(ahb));
        }
    }
}

